#!/usr/bin/perl -w

BEGIN {
	my $WORKDIR = `dirname $0`;
	chomp $WORKDIR;
	chdir $WORKDIR;

	my $ostype = `uname  -s`;
	chomp $ostype;
	unshift @INC, "../ostypes/$ostype";
};

use Time::HiRes qw/sleep/;

use strict;
use arch;

my %pids;
while($_ = shift) {
	my ($ipaddr, $port) = split /:/, $_;

	my @pids = arch::get_listener_pids(
	  ipaddr => $ipaddr, port => $port);
	
	for my $pid (@pids) {
		$pids{$pid} = 1;
	}
}
if(!%pids) {
    exit;
}

kill 15, keys %pids;
sleep 2;

for (1 .. 3) {
	for my $pid (keys %pids) {
		# send KILL
		if(!kill 9, $pid) {
			delete $pids{$pid};
		}
	}
	if(!%pids) {
		exit 0;
	}
	sleep 0.5;
}

exit 1;


