package arch;

use strict;

return 1;
sub get_listener_pids
{
	my (%arg) = @_;
	my $port = $arg{port};
	my $user = $arg{user};
	my $ipaddr = $arg{ipaddr};

	my $search_ipaddr = $ipaddr;
	if($ipaddr eq '0.0.0.0') {
		$search_ipaddr = '*';
	}

	my @pids;
	my @sockstat_output = `sockstat -4l 2>/dev/null`;
	for my $line (@sockstat_output) {
		if($line !~ /^(\S+)\s+\S+\s+(\d+)\s+\d+\s+(tcp4|udp4)\s+(\d+\.\d+\.\d+\.\d+|\*):$port\s+\*:\*$/) {
			next;
		}
		my $found_user = $1;
		my $pid = $2;
		my $proto = $3;
		my $found_ipaddr = $4;

		if(($user && $user ne $found_user) ||
		  ($search_ipaddr && $search_ipaddr ne $found_ipaddr)) {
			next;
		}

		push(@pids, $pid);
	}

	return @pids;
}

