package backup;

use strict;

my $ERROR = '';
my $BCK_DIR = "/opt/dk_getstate/backups";

return 1;

sub new
{
	my (%arg) = @_;
	my $bck_dir = $arg{backup_dir} || $BCK_DIR;
	
	mkdir $bck_dir, 0700;

	my $id = `mktemp -d $bck_dir/XXXXXX`;
	chomp $id;
	chmod 0700, $id;

	return $id;
}

sub do
{
	my (%arg) = @_;
	my $fname = $arg{fname};
	my $bck_id = $arg{id};

	my $ERROR = '';

	my $tmpfile;
	if(!-e $fname) {
		$tmpfile = 'NONEXISTENT';
	} else {

		my $content = read_file($fname);

		$tmpfile = `mktemp $bck_id/XXXXXX`;
		if(($? >> 8) != 0) {
			$ERROR = "Failed to mktemp";
			goto FINISH;
		}

		chomp $tmpfile;

		open(BACKUP_OUT_FD, ">$tmpfile");

		print BACKUP_OUT_FD $content;
		if(!close BACKUP_OUT_FD) {
			$ERROR = "Failed to write backup ($!)";
			goto FINISH;
		}
	}

	open(BACKUP_LIST, ">>$bck_id/backup.list");
	print BACKUP_LIST "$tmpfile\t$fname\n";
	if(!close BACKUP_LIST) {
		$ERROR = "Failed to write backup list ($!)";
		goto FINISH;
	}

FINISH:
	if($ERROR) {
		$backup::ERROR = $ERROR;
		return undef;
	}
}

sub restore
{
	my (%arg) = @_;
	my $bck_id = $arg{id};

	my $ERROR = '';

	if(!open(BACKUP_LIST, "<$bck_id/backup.list")) {
		$ERROR = "Failed to open list ($!)";
		goto FINISH;
	}
	my @backup_list = <BACKUP_LIST>;
	close BACKUP_LIST;

	my @restore_list;

	while(my $line = pop @backup_list) {
		my ($f_id, $fname) = split /\t/, $line;
		chomp $fname;

		if($f_id eq 'NONEXISTENT') {
			unlink $fname;
			next;
		}

		my $tmpfile = `mktemp $fname.DK_RESTORE.XXXXXX`;
		if(($? >> 8) != 0) {
			$ERROR = "Failed to mktemp before restore";
			goto FINISH;
		}
		chomp $tmpfile;
		my $f_content = read_file($f_id);
	
		open(BACKUP_RESTORE_TMP, ">$tmpfile");
		print BACKUP_RESTORE_TMP $f_content;
		if(!close BACKUP_RESTORE_TMP) {
			$ERROR = "Failed to write temp restore file ($!)";
			goto FINISH;
		}

		my @tmp = stat $fname;
		my $mode = $tmp[2];
		my $uid = $tmp[4];
		my $gid = $tmp[5];

		chmod $mode, $tmpfile;
		chown $uid, $gid, $tmpfile;

		push(@restore_list, { fname => $fname, tmp => $tmpfile, } );
	}

	# final rename
	for my $href (@restore_list) {
		rename $href->{tmp}, $href->{fname};
	}

FINISH:
	if($ERROR) {
		$backup::ERROR = $ERROR;
		return undef;
	}

	return 1;
}


sub read_file
{
	my ($fname) = @_;


	if(!open(READ_FILE_FD, "<$fname")) {
		return undef;
	}

	my $content = '';
	while(<READ_FILE_FD>) {
		$content .= $_;
	}
	close READ_FILE_FD;

	return $content;
}
